<?php
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

/* NOTE -- THIS CLASS IS STILL IN TESTING AND MAY BE BUGGY -- MG 1/16/2014 */

/**
* Determines if the parameter is a Message object or a message uid, and if necessary, instantiates the Message object for the uid.
*
* @param int|Message
* @return false|Message
*/
function get_message($message_uid_or_object){
	if(is_a($message_uid_or_object, 'Message')) return $message_uid_or_object;
	$CI = get_instance();
	if(!$CI->is->nonzero_unsigned_integer($message_uid_or_object)) return $CI->error->should_be_a_message_id_or_object($message_uid_or_object);
	try{
		$message = new Message($message_uid_or_object);
	} catch (Exception $e){
		$success = false; //need a variable to return by refrence
		$CI->error->warning('Unable to instantiate a message object for message#'.$message_uid_or_object.': '.$e->getMessage());
		return $success;
	}
	return $message; 
}


/**
* @author M. Gibbs <gibbs_margaret@bah.com>
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Message{
	public $uid;
	public $mailbox;
	public $mailbox_group;
	
	protected $is;
	protected $error;
	protected $imap_connection;
	
	/* DO NOT ACCESS THESE DIRECTLY - CALL THE METHOD WITH THE SAME NAME */
	protected $_overview; 
	protected $_custom_flags; 
	/* END DO NOT ACESS THESE DIRECTLY */	

	const CUSTOM_FLAG_ACTIVE_SUFFIX = '-Active';
	const CUSTOM_FLAG_ID_SUFFIX = '-ID';
		
	/**
	* Connects to IMAP & verifies that the message exists in the current mailbox.
	*/
	public function __construct($uid){		
		$CI = get_instance();		
		$this->error = $CI->error;
		$this->is = $CI->is;
	
		if(!$this->formatted_like_a_message_uid($uid))  throw new Exception('Expected a message $uid, but you gave me '.$this->error->describe($uid)); 
		$this->uid = $uid;
		
		$this->mailbox = element('mailbox', $_SESSION, $CI->session->userdata('login_mailbox'));
		if(empty($this->mailbox)) $this->mailbox = 'INBOX';
		$this->mailbox_group = $CI->session->userdata('mailbox_group'); 
		if(empty($this->mailbox_group))
			$this->mailbox_group = element('mailbox_group', $_SESSION, $CI->session->userdata('username'));

		//get a reference to the main IMAP connection for the script (we don't want to just keep connecting over and over again for every message)		
		$this->imap_connection = imap_connection();
		if(!$this->imap_connection) throw new Exception('Cannot instantiate Message class without an IMAP connection'); 	
					
		//confirm that this message exists in the current mailbox & load the basic info from it	
		if(!is_object($this->overview())) throw new Exception('Could not find a message with $uid '.$this->error->describe($uid).' for '.$this->mailbox_group.'.'.$this->mailbox);
	}
	
	/* Describes this message as usefully as possible for errors. Unfortunately, without a persistent id, we can't describe it that well, but we'll still try to give as much useful info as possible.*/
	public function id_for_error(){
		return $this->mailbox_group.'.'.$this->mailbox.' message#'.$this->uid;
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	// IMAP FLAGS
	// Methods to deal with the standard IMAP flags: recent, answered, deleted, seen, etc.
	/////////////////////////////////////////////////////////////////////////////////////////

#! Tested, including errors, at 12:24	
	public function is_flagged($flag = 'flagged'){
		if(!$this->is_imap_flag($flag)) return $this->error->should_be_an_imap_flag($flag);
		$flag = strtolower($flag);
		return (boolean)$this->overview()->$flag;	
	}
	
	//set one of the standard IMAP flags
#! Tested, including errors, at 12:38	
	public function set_imap_flag($flag){
		if(!$this->is_imap_flag($flag)) return $this->error->should_be_an_imap_flag($flag);
		if(strtolower($flag) == 'recent') return $this->error->should_be_a_writeable_imap_flag($flag);
		if($this->is_flagged($flag)) return true; //we don't need to do anything if it's already flagged.
		$this->_overview = null; //force overview() to reload next time we call it so that we reflect the new state of the flags
		imap_setflag_full($this->imap_connection, $this->uid,'\\'.ucfirst($flag),ST_UID);
		log_imap_errors(); //by default errors will appear unhelpfully at the end of the script, without relevant line numbers - trigger them manually here instead
		if(!$this->is_flagged($flag)) return $this->error->warning('Unable to set IMAP flag \\'.$flag.' for '.$this->id_for_error());
		return true;
	}
	
#! Tested, including errors, at 12:46	
	public function unset_imap_flag($flag){
		if(!$this->is_imap_flag($flag)) return $this->error->should_be_an_imap_flag($flag);
		if(strtolower($flag) == 'recent') return $this->error->should_be_a_writeable_imap_flag($flag);
		if(!$this->is_flagged($flag)) return true; //we don't need to do anything if it's not flagged at the moment.
		$this->_overview = null; //force overview() to reload next time we call it so that we reflect the new state of the flags
		imap_clearflag_full($this->imap_connection, $this->uid,'\\'.ucfirst($flag),ST_UID);
		log_imap_errors(); //by default errors will appear unhelpfully at the end of the script, without relevant line numbers - trigger them manually here instead
		if($this->is_flagged($flag)) return $this->error->warning('Unable to unset IMAP flag \\'.$flag.' for '.$this->id_for_error());
		return true;		
	}
				
	/////////////////////////
	/// CUSTOM FLAGS
	/// 
	//////////////////////////
	
	/**
	* True if the message has any custom flags.
	* Note that this is a lower overhead check than actually calling custom_flags(), so it's worth checking this first.
	* @return boolean
	*/
#! TESTED & CONFIRMED AT 10:30		
	public function has_custom_flags(){
#		return $this->is_flagged('flagged');
		$flags = $this->custom_flags();
		return !empty($flags);
	}
	
	/**
	* @param string
	* @return boolean
	*/
#! TESTED & CONFIRMED AT 10:30	
	public function custom_flag_is_active($flag_prefix){
		if(!$this->is->nonempty_string($flag_prefix)) return $this->error->should_be_a_nonempty_string($flag_prefix);
		if(!$this->has_custom_flags()) return false; //this is a lower overhead check, so do it before we grab the custo flags
		if(!$this->has_custom_flag_id($flag_prefix)) return false; //flag can't be active if it doesn't actually have a value
		$flag = strtolower(strip_from_end('-', $flag_prefix)).$this::CUSTOM_FLAG_ACTIVE_SUFFIX;
		return in_array($flag, $this->custom_flags());
	}
	
#! TESTED & CONFIRMED AT 10:30		
	public function activate_custom_flag($flag_prefix){
		if(!$this->is->nonempty_string($flag_prefix)) return $this->error->should_be_a_nonempty_string($flag_prefix);
		if(!$this->has_custom_flag_id($flag_prefix)) return $this->error->warning('Cannot activate custom flag '.$flag_prefix.' without a flag id for '.$this->id_for_error());
		$flag = strtolower(strip_from_end('-', $flag_prefix)).$this::CUSTOM_FLAG_ACTIVE_SUFFIX;
		return $this->_set_custom_flag($flag);	
	}

#! TESTED & CONFIRMED AT 10:30		
	public function deactivate_custom_flag($flag_prefix){
		if(!$this->custom_flag_is_active($flag_prefix)) return true;
		$flag = strtolower(strip_from_end('-', $flag_prefix)).$this::CUSTOM_FLAG_ACTIVE_SUFFIX;
		return $this->_unset_custom_flag($flag);
	}
	
#! Tested & confirmed at 9:54 pm	
	public function has_custom_flag_id($flag_prefix){
		$id = $this->custom_flag_id($flag_prefix);
		return $this->is->nonzero_unsigned_integer($id);
	}
	
	/**
	* @param string
	* @return int|false
	*/
#! Tested & confirmed at 9:53pm	
	public function custom_flag_id($flag_prefix){
		if(!$this->is->nonempty_string($flag_prefix)) return $this->error->should_be_a_nonempty_string($flag_prefix);
		
		if(!$this->has_custom_flags()) return false; //to reduce overhead, just return false if there are no custom flags for this message
		$flag_prefix = strtolower(strip_from_end('-', $flag_prefix)).$this::CUSTOM_FLAG_ID_SUFFIX.'-';
		
		foreach($this->custom_flags() as $custom_flag){
			if(string_begins_with($flag_prefix, $custom_flag)){
				return strip_from_beginning($flag_prefix, $custom_flag);
			}
		}
		return false; //no flag id exists
	}
		
#! Tested & confirmed at 9:53pm		
	public function set_custom_flag_id($flag_prefix, $id){
		if(!$this->is->nonempty_string($flag_prefix)) return $this->error->should_be_a_nonempty_string($flag_prefix);
		if(!$this->is->nonzero_unsigned_integer($id)) return $this->error->should_be_a_nonzero_unsigned_integer($id);
		
		$active_to_start = $this->custom_flag_is_active($flag_prefix);
		
		//remove the flag if it's already set - we don't want to end up with a bunch of these
		if($this->has_custom_flag_id($flag_prefix)){
			$this->unset_custom_flag_id($flag_prefix);
		}

		if($active_to_start && !$this->custom_flag_is_active($flag_prefix)) $this->activate_custom_flag($flag_prefix);

		
		$flag = strtolower(strip_from_end('-', $flag_prefix)).$this::CUSTOM_FLAG_ID_SUFFIX.'-'.$id;
		return $this->_set_custom_flag($flag);
	}

	public function unset_custom_flag_id($flag_prefix){
		if(!$this->is->nonempty_string($flag_prefix)) return $this->error->should_be_a_nonempty_string($flag_prefix);
		
		$active_to_start = $this->custom_flag_is_active($flag_prefix);
		$this->deactivate_custom_flag($flag_prefix);
		
		$flag_for_removal = strtolower($flag_prefix).$this::CUSTOM_FLAG_ID_SUFFIX.'-'.$this->custom_flag_id($flag_prefix);
		$success = $this->_unset_custom_flag($flag_for_removal);
		if(!$success && $active_to_start) $this->activate_custom_flag($flag_prefix);
		
		//make sure that we don't end up with more than one flag id - remove ALL the flags with this prefix.
		while($this->has_custom_flag_id($flag_prefix)){
			foreach($this->_custom_flags() as $custom_flag){
				if(string_begins_with(strtolower($flag_prefix).$this::CUSTOM_FLAG_ID_SUFFIX, $custom_flag)){
					$success = $this->_unset_custom_flag($custom_flag);
					if(!$success && $active_to_start) $this->activate_custom_flag($flag_prefix);
					if(!$success) return $this->error->warning('Unable to unset '.$custom_flag.' for '.$this->id_for_error());
				}
			}
		}
				
		return true;
	}
	
#TODO - SET BACK TO PROTECTED WHEN TESTING IS DONE	
#! TESTED & CONFIRMED AT 10:30	
	protected function _set_custom_flag($flag){
		if(!$this->is->nonempty_string($flag)) return $this->error->should_be_a_nonempty_string($flag);
		
		//check to see if the flag is already set -- if it is, we're done!
		if(in_array($flag, $this->_custom_flags())) return true; 	
		
		//clear the custom flags - we'll reload them after we set the new flag		
		$this->_custom_flags = null; 
		
		//set the flag via imap and check for errors
		$success = imap_setflag_full($this->imap_connection, $this->uid,$flag,ST_UID);
		log_imap_errors(); 
		if(!$success) return $this->error->warning('Could not set custom flag '.$flag.' for '.$this->id_for_error());
		
		//check to make sure that the flag really got set
#		if(!in_array($flag, $this->custom_flags())) return false;
		if(!in_array($flag, $this->_custom_flags())) return false;  
		
		//if we're really set, make sure that we've indicated that the message has custom flags
		$this->set_imap_flag('flagged');
		return true;
	}
	
#TODO - SET BACK TO PROTECTED WHEN TESTING IS DONE
#! TESTED & CONFIRMED AT 10:30	
	protected function _unset_custom_flag($flag){
		if(!$this->is->nonempty_string($flag)) return $this->error->should_be_a_nonempty_string($flag);
		
		//check to make sure this is really flagged - if it's not, we don't need to do anything
#		if(!$this->has_custom_flags()) return true; 
#		if(!in_array($flag, $this->custom_flags())) return true; 
		if(!in_array($flag, $this->_custom_flags())) return true;
		
		//if we're getting rid of the last custom flag, unset the \\Flagged flag
		if(count($this->_custom_flags()) < 2) $this->unset_imap_flag('flagged');
		
		//clear the custom flags - we'll reload them after we unset the flag		
		$this->_custom_flags = null; 
		
		//unset the flag via imap and check for errors
		imap_clearflag_full($this->imap_connection, $this->uid,$flag,ST_UID);
		log_imap_errors();
		
		//make sure the flag really got unset - if not, reset our flagged indicator
		if(in_array($flag, $this->custom_flags())){
			$this->set_imap_flag('flagged');
			return false;
		}
		
		return true;		
	}
	
	///////////////////////////////////////////
	// ACCESSORS
	///////////////////////////////////////////
	
#! TESTED & CONFIRMED AT 10:30	
	public function custom_flags(){
#		if(!$this->has_custom_flags()) return array();
		return $this->_custom_flags();
	}
	
#TODO - SWITCH BACK TO PROTECTED
#! TESTED & CONFIRMED AT 10:30		
	public function _custom_flags(){
		if(!isset($this->_custom_flags) || is_null($this->_custom_flags)){
			
			//check to see if we can establish an imap socket.  if we can't, we don't need to shut down the whole page - custom flags just won't be available.
			if(!is_object($this->imap_socket())){
				$this->error->warning('Unable to retrieve custom flags: message flags and workflow items will not be available for '.$this->id_for_error());
				return array();
			}
			
			//retrieve the flags 
#TODO - FIGURE OUT WHY THIS ONLY WORKS WHEN WE MAKE THE GET_FLAGS CALL TWICE.  THIS ... SEEMS ODD. MAYBE IT WILL BE CLEAR AFTER SOME SLEEP.	
			$this->imap_socket()->get_flags($this->uid);
			$this->_custom_flags = $this->imap_socket()->get_flags($this->uid);	
			foreach($this->_custom_flags as $key => $flag){
				//don't include the standard imap flags
				if(empty($flag) || $this->is_imap_flag(strip_from_beginning('\\', $flag)))
					unset($this->_custom_flags[$key]);
			}
		}
		return $this->_custom_flags;
	}
	
	
	function imap_socket(){
		$CI = get_instance();
		if(!isset($CI->imapsocket)){
# TODO - test this again to make sure we don't hit up the socket more often than we want to			
#			$this->error->notice('Now instantiating imapsocket', 1);
			try{
				$options = array(
					'login' => $CI->session->userdata('username'),
					'password' => $CI->encrypt->decode($CI->session->userdata('ep')),
					'mailbox' => $this->mailbox,
				);
				$CI->load->library('imapsocket',$options);
			} catch (Exception $e){
				$success = false; //since we're returning by reference, we need to reference an actual variable.
				$this->error->warning('Unable to establish IMAP socket connection: '.$e->getMessage());
				return $success;
			}
		}
		return $CI->imapsocket;
	}	
	
	public function overview(){
		if(!isset($this->_overview)){
			$this->_overview = first_element(imap_fetch_overview($this->imap_connection, $this->uid, FT_UID));
			if(!is_object($this->_overview)) return $this->error->warning("I can't find a message with uid ".$this->error->describe($this->uid).' for '.$this->mailbox_group.'::'.$this->mailbox);
		}
		return $this->_overview;
	}
	
	///////////////////////////////////////////////
	// VALIDATION
	//////////////////////////////////////////////
	public function formatted_like_a_message_uid($uid){
		return is_scalar($uid) && !empty($uid);
	}
	
	public function is_imap_flag($flag){
		if(!$this->is->nonempty_string($flag)) return $this->error->should_be_a_nonempty_string($flag);
		return in_array(strtolower($flag), array('recent', 'flagged', 'answered', 'deleted', 'seen', 'draft'));
	}
	
	
}